/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.StrengthPower;
import com.megacrit.cardcrawl.powers.WeakPower;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;

public class Malaise
extends AbstractCard {
    public static final String ID = "Malaise";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Malaise");
    public static final String NAME = Malaise.cardStrings.NAME;
    public static final String DESCRIPTION = Malaise.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = Malaise.cardStrings.UPGRADE_DESCRIPTION;
    private static final int COST = -1;
    private static final int POOL = 1;

    public Malaise() {
        super(ID, NAME, "green/skill/poisonGlobe", "green/skill/malaise", -1, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.exhaust = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m, int energyAmount) {
        int effect = energyAmount;
        if (p.hasRelic("Chemical X")) {
            effect += 2;
            p.getRelic("Chemical X").flash();
        }
        if (this.upgraded) {
            ++effect;
        }
        if (effect > 0) {
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, p, new StrengthPower(m, -effect), -effect));
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, p, new WeakPower(m, effect, false), effect));
            if (!this.freeToPlayOnce) {
                p.energy.use(EnergyPanel.totalCount);
            }
        }
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m, EnergyPanel.totalCount);
    }

    @Override
    public AbstractCard makeCopy() {
        return new Malaise();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.rawDescription = UPGRADE_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

